/*
 * Decompiled with CFR 0.152.
 */
package standard;

import basis.Farbe;
import basis.Pos;
import basis.Stein;
import cbge.CBScreen;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class Feld
implements Serializable {
    private static final long serialVersionUID = 1L;
    static int radius;
    private double code;
    private int weiss;
    private int schwarz;
    private boolean schutz;
    private boolean vergiftung;
    private int[] eckenX;
    private int[] eckenY;
    private double x;
    private double y;
    private int kx;
    private int ky;
    private Dimension dim;
    private int l;
    int[][] feldInfo;
    private int basisfeld = 0;
    private int nummer;
    int z = 1;
    Stein s;
    private Feld[] umgebung = new Feld[6];

    public static Feld[] build(String path) throws IOException {
        String linie;
        BufferedReader br = new BufferedReader(new FileReader(path));
        Stack<int[]> zeilen = new Stack<int[]>();
        int z = 0;
        while ((linie = br.readLine()) != null) {
            String[] zeileStr = linie.split(" ");
            int[] zeile = new int[zeileStr.length * 2 - 1];
            int i = 0;
            while (i < zeileStr.length) {
                int n = Integer.parseInt(zeileStr[i]);
                zeile[zeile.length - i - 1] = n;
                zeile[i] = n;
                ++i;
            }
            zeilen.push(zeile);
            ++z;
        }
        br.close();
        z = z * 2 - 1;
        int[][] feldInfo = new int[z][];
        int i = 0;
        while (i <= z / 2) {
            int[] nArray = (int[])zeilen.pop();
            feldInfo[z / 2 + i] = nArray;
            feldInfo[z / 2 - i] = nArray;
            ++i;
        }
        return Feld.build(feldInfo);
    }

    public static Feld[] build(int[][] feldInfo) throws IOException {
        int n;
        Object object;
        int z = feldInfo.length;
        Feld[][] feld = new Feld[z][];
        int i = 0;
        while (i < z) {
            int sum = 0;
            int zz = 0;
            object = feldInfo[i];
            int n2 = ((int[])object).length;
            n = 0;
            while (n < n2) {
                int j = object[n];
                sum += j;
                ++n;
            }
            feld[i] = new Feld[sum];
            boolean leer = false;
            int j = 0;
            while (j < feldInfo[i].length) {
                int k = 0;
                while (k < feldInfo[i][j]) {
                    feld[i][zz++] = leer ? null : new Feld();
                    ++k;
                }
                leer = !leer;
                ++j;
            }
            ++i;
        }
        int aktNum = 1;
        int i2 = 0;
        while (i2 < z) {
            int j = 0;
            while (j < feld[i2].length) {
                if (feld[i2][j] != null) {
                    feld[i2][j].nummer = aktNum++;
                    Feld[] umgebung = new Feld[6];
                    int k = 0;
                    while (k < 6) {
                        Feld f = null;
                        try {
                            int m = k < 3 ? 1 : -1;
                            int n3 = 0;
                            int a = 0;
                            int b = 0;
                            int c = 0;
                            if (k % 3 != 0) {
                                n3 = feld[i2].length;
                                a = j - n3 / 2 - n3 % 2;
                                b = feld[i2 + m].length / 2;
                                c = k % 2;
                            }
                            switch (k) {
                                case 0: 
                                case 3: {
                                    f = feld[i2][j + m];
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 4: 
                                case 5: {
                                    f = feld[i2 + m][a + b + c];
                                }
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            f = null;
                        }
                        umgebung[k] = f;
                        ++k;
                    }
                    feld[i2][j].umgebung = umgebung;
                }
                ++j;
            }
            ++i2;
        }
        int y = feld.length / 2;
        int x = feld[0].length;
        object = feld;
        int n4 = feld.length;
        n = 0;
        while (n < n4) {
            int l = object[n];
            x = Math.max(x, ((int)l).length);
            ++n;
        }
        Feld[] basisfelder = new Feld[]{feld[y][0], feld[y][feld[y].length - 1]};
        basisfelder[0].basisfeld = 1;
        basisfelder[0].z = 3;
        basisfelder[1].basisfeld = -1;
        basisfelder[1].z = 4;
        basisfelder[0].dim = new Dimension(x, feld.length);
        basisfelder[0].l = feld[y].length;
        basisfelder[0].feldInfo = feldInfo;
        basisfelder[0].position();
        return basisfelder;
    }

    void position() {
        double width = CBScreen.getWidth();
        double height = CBScreen.getHeight();
        double w = this.dim.getWidth();
        double h = this.dim.getHeight();
        double r = Math.min((width - 12.0) / 2.0 / w, (height - 12.0) / ((h - 1.0) * Math.sqrt(3.0) + 4.0 / Math.sqrt(3.0)));
        this.position(width / 2.0 - (double)this.l * r + r, height / 2.0, r, 0, 0, Math.random());
        radius = (int)r;
    }

    private void position(double x, double y, double radius, int kx, int ky, double code) {
        double ang;
        if (this.code == code) {
            return;
        }
        this.code = code;
        this.kx = kx;
        this.ky = ky;
        this.x = x;
        this.y = y;
        int i = 0;
        while (i < 6) {
            if (this.umgebung[i] != null) {
                int dx;
                ang = 1.0471975511965976 * (double)i;
                int n = i == 0 || i == 1 ? 1 : (dx = i == 5 || i == 2 ? 0 : -1);
                int dy = i == 5 || i == 4 ? 1 : (i == 0 || i == 3 ? 0 : -1);
                this.umgebung[i].position(x + Math.cos(ang) * radius * 2.0, y + Math.sin(ang) * radius * 2.0, radius, kx + dx, ky + dy, code);
            }
            ++i;
        }
        this.eckenX = new int[6];
        this.eckenY = new int[6];
        radius *= 2.0 / Math.sqrt(3.0);
        i = 0;
        while (i < 6) {
            ang = 1.0471975511965976 * ((double)i + 0.5);
            this.eckenX[i] = (int)Math.round(x + Math.cos(ang) * radius);
            this.eckenY[i] = (int)Math.round(y + Math.sin(ang) * radius);
            ++i;
        }
    }

    private void paint(Graphics g, double code) {
        if (this.code == code) {
            if (this.basisfeld == 0) {
                return;
            }
            Farbe.stein(g, 7);
            g.drawPolygon(this.eckenX, this.eckenY, 6);
            return;
        }
        this.code = code;
        if (this.z < 0) {
            Farbe.stein(g, 7);
        } else {
            Farbe.feld(g, this.z);
        }
        g.fillPolygon(this.eckenX, this.eckenY, 6);
        Farbe.feld(g, 5);
        g.drawPolygon(this.eckenX, this.eckenY, 6);
        if (this.s != null) {
            this.s.paint(g, (int)this.x, (int)this.y, radius - 3);
        }
        int i = 0;
        while (i < 6) {
            if (this.umgebung[i] != null) {
                this.umgebung[i].paint(g, code);
            }
            ++i;
        }
        g.setFont(new Font("", 0, 9));
        Farbe.feld(g, 5);
        if (this.nummer < 10) {
            g.drawString(String.valueOf(this.nummer), this.eckenX[1] - 2, this.eckenY[1] - 3);
        } else if (this.nummer < 100) {
            g.drawString(String.valueOf(this.nummer), this.eckenX[1] - 4, this.eckenY[1] - 3);
        } else {
            g.drawString(String.valueOf(this.nummer), this.eckenX[1] - 7, this.eckenY[1] - 3);
        }
    }

    void repaint() {
        this.paint(CBScreen.getGraphics(), Math.random());
    }

    private int[] pfeil(boolean weiss, int n, int richtung, double code) {
        int i;
        int[] anz = new int[2];
        if (this.code != code) {
            this.code = code;
            this.weiss = this.basisfeld == 1 ? 1 : 0;
            this.schwarz = this.basisfeld == -1 ? 1 : 0;
            this.vergiftung = false;
            this.schutz = false;
            i = 0;
            while (i < 6) {
                if (this.umgebung[i] != null) {
                    int[] a = new int[2];
                    boolean b = false;
                    if (this.s != null) {
                        int p = this.s.getPfeil(i);
                        if (p == 0) {
                            b = true;
                        } else {
                            int p1 = p % 10;
                            int p2 = p / 10;
                            a = this.umgebung[i].pfeil(this.s.weiss, p1, i, code);
                            if (p2 != 0) {
                                this.umgebung[i].pfeil(this.s.weiss, p2, i, code);
                            }
                        }
                    } else {
                        b = true;
                    }
                    if (b) {
                        a = this.umgebung[i].pfeil(weiss, 0, 0, code);
                    }
                    anz[0] = anz[0] + a[0];
                    anz[1] = anz[1] + a[1];
                }
                ++i;
            }
            if (this.s != null && this.s.echt) {
                if (this.s.weiss) {
                    anz[0] = anz[0] + 1;
                } else {
                    anz[1] = anz[1] + 1;
                }
            }
        }
        if (--n == 0) {
            i = weiss ? 1 : 0;
            int j = 1 - i;
            if (this.s != null && this.s.weiss != weiss) {
                if (!this.vergiftung && this.s.kreis == -1) {
                    this.vergiftung = true;
                    if (weiss) {
                        ++i;
                    } else {
                        ++j;
                    }
                } else if (!this.schutz && this.s.kreis == 1) {
                    this.schutz = true;
                    if (!weiss) {
                        ++i;
                    } else {
                        ++j;
                    }
                }
            }
            this.weiss += i;
            this.schwarz += j;
        } else if (n > 0 && this.umgebung[richtung] != null && this.s == null) {
            this.umgebung[richtung].pfeil(weiss, n, richtung, code);
        }
        if (this.z > 0) {
            this.z = this.weiss == 0 && this.schwarz == 0 ? 1 : (this.weiss == this.schwarz ? 2 : (this.weiss > this.schwarz ? 3 : 4));
        }
        return anz;
    }

    public int[] check() {
        int[] anz = this.pfeil(true, 0, 0, Math.random());
        return anz;
    }

    private Map<Pos, Integer> getSteine(Map<Pos, Integer> stack, double code) {
        if (this.code != code) {
            this.code = code;
            Pos pos = new Pos(this.kx, this.ky);
            if (this.s != null) {
                stack.put(pos, this.s.code());
            }
            int i = 0;
            while (i < 6) {
                if (this.umgebung[i] != null) {
                    stack = this.umgebung[i].getSteine(stack, code);
                }
                ++i;
            }
        }
        return stack;
    }

    Map<Pos, Integer> getSteine() {
        return this.getSteine(new HashMap<Pos, Integer>(), Math.random());
    }

    private Feld find(int kx, int ky, double code) {
        if (this.code != code) {
            this.code = code;
            if (this.kx == kx && this.ky == ky) {
                return this;
            }
            int i = 0;
            while (i < 6) {
                Feld f;
                if (this.umgebung[i] != null && (f = this.umgebung[i].find(kx, ky, code)) != null) {
                    return f;
                }
                ++i;
            }
        }
        return null;
    }

    Feld find(int kx, int ky) {
        return this.find(kx, ky, Math.random());
    }

    private Feld click(int x, int y, double code) {
        if (this.code == code) {
            return null;
        }
        this.code = code;
        if (Math.sqrt(Math.pow(this.x - (double)x, 2.0) + Math.pow(this.y - (double)y, 2.0)) < (double)radius) {
            return this;
        }
        int i = 0;
        while (i < 6) {
            Feld nachbar;
            if (this.umgebung[i] != null && (nachbar = this.umgebung[i].click(x, y, code)) != null) {
                return nachbar;
            }
            ++i;
        }
        return null;
    }

    Feld click(int x, int y) {
        return this.click(x, y, Math.random());
    }
}

