/*
 * Decompiled with CFR 0.152.
 */
package cbge.sound;

import cbge.CBError;
import cbge.CBThread;
import cbge.data.CBStream;
import cbge.sound.CBSoundListener;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class CBSound {
    public static double shiftSpeed = 0.5;
    public static double musicShiftDuration = 3.0;
    private static final String format = ".ogg";
    private static transient String root;
    private static boolean enabled;
    private static CBSound music;
    private FloatControl control;
    private double min;
    private double max;
    private boolean interrupted = false;
    private boolean adjusted = false;
    private CBSoundListener sl;
    private SourceDataLine line;

    static {
        enabled = true;
    }

    public static void setRoot(String path) {
        root = path == null ? "" : path;
    }

    public void setEnabled(boolean set) {
        enabled = set;
        CBSound.music();
    }

    public static CBSound sound(String path, String name) {
        return CBSound.sound(path, name, 0.5, null);
    }

    public static CBSound sound(String path, String name, double volumen) {
        return CBSound.sound(path, name, volumen, null);
    }

    public static CBSound sound(String path, String name, CBSoundListener sl) {
        return CBSound.sound(path, name, 0.5, sl);
    }

    public static CBSound sound(String path, String name, double volumen, CBSoundListener sl) {
        return CBSound.sound(CBStream.get(CBSound.combine(root, path), String.valueOf(name) + format), volumen, sl);
    }

    public static CBSound sound(InputStream stream, double volumen, CBSoundListener sl) {
        CBSound sound = new CBSound(sl);
        new Thread(() -> sound.play(stream, volumen)).start();
        return sound;
    }

    public static boolean music() {
        return CBSound.music(0.0);
    }

    public static boolean music(double duration) {
        if (music != null) {
            music.stop(duration);
            music = null;
            return true;
        }
        return false;
    }

    public static void music(double volumen, double duration) {
        if (music != null) {
            music.volumen(volumen, duration);
        }
    }

    public static void music(String path, String name) {
        CBSound.music(path, name, 0.5, null);
    }

    public static void music(String path, String name, double volumen) {
        CBSound.music(path, name, volumen, null);
    }

    public static void music(String path, String name, CBSoundListener sl) {
        CBSound.music(path, name, 0.5, sl);
    }

    public static void music(String path, String name, double volumen, CBSoundListener sl) {
        if (music != null) {
            music.stop(musicShiftDuration);
            while (!CBSound.music.interrupted) {
                Thread.yield();
            }
        }
        music = CBSound.sound(path, name, volumen, interrupted -> {
            if (!interrupted) {
                music = null;
            }
            if (sl != null) {
                sl.trackEnded(interrupted);
            }
        });
    }

    private static String combine(String a, String b) {
        if ("".equals(a)) {
            return b;
        }
        if ("".equals(b)) {
            return a;
        }
        return String.valueOf(a) + "/" + b;
    }

    private CBSound(CBSoundListener sl) {
        this.sl = sl;
    }

    private void volumen(FloatControl control, double volumen) {
        float value = (float)(Math.log10((this.max - this.min) * volumen + this.min) * 20.0);
        value = Math.min(control.getMaximum(), Math.max(control.getMinimum(), value));
        control.setValue(value);
        this.control = control;
    }

    public void volumen(double volumen) {
        this.volumen(volumen, 0.0);
    }

    public void volumen(double volumen, double duration) {
        if (volumen < 0.0 || volumen > 1.0) {
            CBError.error("cbge.sound.CBSound.volumen(double, double): Volumen " + volumen + " ist ung\u00fcltig (0-1)");
        }
        if (duration < 0.0) {
            CBError.error("cbge.sound.CBSound.volumen(double, double): Dauer " + duration + " ist ung\ufffdltig (>0)");
        }
        this.adjusted = false;
        new Thread(() -> {
            while (this.control == null) {
                Thread.yield();
            }
            float newValue = (float)(Math.log10((this.max - this.min) * volumen + this.min) * 20.0);
            newValue = Math.min(this.control.getMaximum(), Math.max(this.control.getMinimum(), newValue));
            if (duration > 0.0) {
                this.shift(this.control.getValue(), newValue, duration);
            } else {
                this.control.setValue(newValue);
                this.adjusted = true;
            }
        }).start();
    }

    private void shift(double from, final double to, final double duration) {
        new CBThread(){
            private double progress = 0.0;
            private double from;

            @Override
            public void work(double fps) {
                double d;
                float newValue = (float)(duration == 0.0 ? to : (to - this.from) * Math.pow(this.progress / duration, 1.0 / shiftSpeed) + this.from);
                newValue = Math.min(CBSound.this.control.getMaximum(), Math.max(CBSound.this.control.getMinimum(), newValue));
                CBSound.this.control.setValue(newValue);
                this.progress += 1.0 / fps;
                if (d > duration) {
                    this.stop();
                }
            }

            @Override
            public void end() {
                CBSound.this.adjusted = true;
            }
        }.start();
    }

    public void stop() {
        this.stop(0.0);
    }

    public void stop(double duration) {
        this.volumen(0.0, duration);
        new Thread(() -> {
            while (!this.adjusted) {
                Thread.yield();
            }
            this.interrupted = true;
        }).start();
    }

    private void play(InputStream is, double volumen) {
        if (!enabled) {
            return;
        }
        try {
            AudioInputStream in = AudioSystem.getAudioInputStream(is);
            AudioFormat baseFormat = in.getFormat();
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            AudioInputStream din = AudioSystem.getAudioInputStream(decodedFormat, in);
            this.rawplay(decodedFormat, din, volumen);
            in.close();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            CBError.error("cbge.sound.CBSound.play(InputStream, double): Exception", e);
        }
    }

    private void rawplay(AudioFormat targetFormat, AudioInputStream din, double volumen) throws IOException, LineUnavailableException {
        byte[] data = new byte[4096];
        if (this.line == null) {
            this.line = this.getLine(targetFormat, volumen);
        }
        if (this.line != null) {
            this.line.start();
            int nBytesRead = 0;
            while (!this.interrupted && nBytesRead != -1) {
                nBytesRead = din.read(data, 0, data.length);
                if (nBytesRead == -1) continue;
                this.line.write(data, 0, nBytesRead);
            }
            this.line.drain();
            if (this.sl != null) {
                this.sl.trackEnded(this.interrupted);
            }
            this.line.stop();
            this.line.close();
            din.close();
        }
    }

    private SourceDataLine getLine(AudioFormat audioFormat, double volumen) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(audioFormat);
        FloatControl control = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        this.min = Math.pow(10.0, control.getMinimum() / 20.0f);
        this.max = Math.pow(10.0, control.getMaximum() / 20.0f);
        this.volumen(control, volumen);
        return line;
    }
}

