/*
 * Decompiled with CFR 0.152.
 */
package cbge.net;

import cbge.CBError;
import cbge.net.CBProtocol;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CBSocket {
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private ConcurrentLinkedQueue<String> queue;
    private boolean connected = false;

    public int connect(String name) {
        return this.connect(CBProtocol.web("http://www.osyfe.de/server/ip.html"), Integer.parseInt(CBProtocol.web("http://www.osyfe.de/server/port.html")), name);
    }

    public int connect(String host, int port, String name) {
        if (name == null || "".equals(name)) {
            return 0;
        }
        try {
            this.socket = new Socket(host, port);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                CBError.error("cbge.net.CBClient.<init>(Socket)", e);
            }
            this.connected = true;
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.out.writeUTF(name);
            if (!this.in.readBoolean()) {
                this.close();
                return 0;
            }
        }
        catch (ConnectException e) {
            return -1;
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBSocket.<init>(String)", e);
        }
        this.queue = new ConcurrentLinkedQueue();
        new Thread(() -> this.listen()).start();
        return 1;
    }

    private void listen() {
        while (this.connected) {
            String receive = null;
            try {
                receive = this.in.readUTF();
            }
            catch (Exception e) {
                this.close();
                break;
            }
            this.queue.add(receive);
        }
    }

    public int available() {
        if (this.connected) {
            return this.queue.size();
        }
        return -1;
    }

    public CBProtocol receive() {
        if (!this.queue.isEmpty()) {
            return new CBProtocol(this.queue.poll());
        }
        return null;
    }

    public void close() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBSocket.close()", e);
        }
    }

    public boolean send(CBProtocol prot) {
        try {
            this.out.writeUTF(prot.toString());
            return true;
        }
        catch (SocketException e) {
            this.close();
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBSocket.send(String)", e);
        }
        return false;
    }

    public boolean connected() {
        return this.connected;
    }
}

