/*
 * Decompiled with CFR 0.152.
 */
package cbge.net;

import cbge.CBError;
import cbge.net.CBProtocol;
import cbge.net.CBServer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;

final class CBClient {
    String name;
    HashSet<String> labels = new HashSet();
    Socket client;
    DataInputStream in;
    DataOutputStream out;
    ConcurrentLinkedQueue<String> queue;

    CBClient(Socket client) {
        this.client = client;
        try {
            client.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            CBError.error("cbge.net.CBClient.<init>(Socket)", e);
        }
        try {
            this.in = new DataInputStream(client.getInputStream());
            this.out = new DataOutputStream(client.getOutputStream());
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBClient.<init>(Socket)", e);
        }
        this.queue = new ConcurrentLinkedQueue();
    }

    void listen() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (CBServer.run) {
                    String receive = null;
                    try {
                        receive = CBClient.this.in.readUTF();
                    }
                    catch (IOException e) {
                        CBServer.died(CBClient.this.name);
                        CBClient.this.close();
                        break;
                    }
                    CBClient.this.queue.add(receive);
                }
            }
        }).start();
    }

    void send(CBProtocol prot) {
        try {
            this.out.writeUTF(prot.toString());
        }
        catch (SocketException e) {
            CBError.error("cbge.net.CBCLient.send(String)", e);
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBCLient.send(String)", e);
        }
    }

    void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBClient.close()", e);
        }
    }
}

