/*
 * Decompiled with CFR 0.152.
 */
package cbge;

import cbge.CBError;

public abstract class CBThread {
    public static int MAX_FPS = 50;
    private boolean run = false;
    private boolean inLoop = false;
    private double speed = 1.0;
    private long pause = 0L;
    private CBThread syncro = this;
    private boolean syncronized = false;

    public Thread start() {
        if (this.run) {
            CBError.error("cbge.CBThread.start(): Thread ist bereits aktiv");
        }
        try {
            this.init();
        }
        catch (InitializationInterruptedException e) {
            this.end();
            return null;
        }
        this.run = true;
        Thread t = new Thread((new Runnable(){
            private CBThread thread;

            private Runnable setThread(CBThread t) {
                this.thread = t;
                return this;
            }

            @Override
            public void run() {
                double fps = MAX_FPS;
                long time = System.nanoTime();
                while (CBThread.this.run) {
                    CBThread.this.inLoop = true;
                    this.thread.work(fps / CBThread.this.speed);
                    CBThread.this.syncro.syncronized = true;
                    while (!CBThread.this.syncronized) {
                        Thread.yield();
                    }
                    CBThread.this.syncronized = false;
                    long newTime = System.nanoTime();
                    while (1.0E9 / (double)(newTime - time - CBThread.this.pause) > (double)MAX_FPS) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        newTime = System.nanoTime();
                    }
                    fps = (1.0E9 / (double)(newTime - time - CBThread.this.pause) + fps) / 2.0;
                    time = newTime;
                    CBThread.this.pause = 0L;
                    CBThread.this.inLoop = false;
                }
            }
        }).setThread(this));
        t.start();
        return t;
    }

    public void stop() {
        if (!this.run) {
            CBError.error("cbge.CBThread.stop(): Thread ist noch nicht aktiv");
        }
        this.run = false;
        new Thread(() -> {
            while (this.inLoop) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.syncro.syncronized = true;
            this.end();
        }).start();
    }

    public void quitLoop() {
        this.pause = System.nanoTime();
    }

    public void enterLoop() {
        this.pause = System.nanoTime() - this.pause;
    }

    public boolean paused() {
        return this.pause != 0L;
    }

    public double speed() {
        return this.speed;
    }

    public void speed(double speed) {
        this.speed = speed;
    }

    public boolean run() {
        return this.run;
    }

    protected void init() throws InitializationInterruptedException {
    }

    protected void end() {
    }

    protected abstract void work(double var1);

    public void syncronize(CBThread newThread) {
        newThread.syncro = this.syncro;
        this.syncro = newThread;
    }

    public static class InitializationInterruptedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

