/*
 * Decompiled with CFR 0.152.
 */
package basis;

import basis.Farbe;
import cbge.physics.CBVector;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Arrays;

public class Stein
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] pfeile = new int[6];
    private int position = 0;
    public int kreis = 0;
    public boolean weiss;
    public boolean echt = true;

    public Stein(int code) {
        int s = code / 1000000;
        boolean bl = this.weiss = s < 5;
        if (!this.weiss) {
            s -= 5;
        }
        boolean bl2 = this.echt = s != 4;
        this.kreis = s == 1 || s == 4 ? 0 : (s == 2 ? 1 : -1);
        this.pfeile = new int[6];
        int f = 1;
        int w = 0;
        while (w < 6) {
            int c = code / f % 10;
            this.pfeile[w] = c < 4 ? c : (c < 7 ? (c - 3) * 10 + c - 3 : (c < 9 ? c - 5 + 10 : 23));
            f *= 10;
            ++w;
        }
    }

    public Stein(boolean weiss, int ... pfeile) {
        this.weiss = weiss;
        System.arraycopy(pfeile, 0, this.pfeile, 0, 6);
    }

    private Stein(boolean weiss, boolean echt, int schutz, int position, int ... pfeile) {
        this.weiss = weiss;
        this.echt = echt;
        this.kreis = schutz;
        this.position = position;
        System.arraycopy(pfeile, 0, this.pfeile, 0, 6);
    }

    public void turn(int times) {
        if (times == 0) {
            this.pfeile[1] = this.pfeile[1] + this.pfeile[5];
            this.pfeile[2] = this.pfeile[2] + this.pfeile[4];
            this.pfeile[5] = this.pfeile[1] - this.pfeile[5];
            this.pfeile[4] = this.pfeile[2] - this.pfeile[4];
            this.pfeile[1] = this.pfeile[1] - this.pfeile[5];
            this.pfeile[2] = this.pfeile[2] - this.pfeile[4];
        } else {
            this.position -= times;
            while (this.position < 0) {
                this.position += 6;
            }
            this.position %= 6;
        }
    }

    public Stein copy() {
        return new Stein(this.weiss, this.echt, this.kreis, this.position, Arrays.copyOf(this.pfeile, 6));
    }

    public void up() {
        this.kreis = this.kreis != 0 ? 0 : 1;
    }

    public void down() {
        this.kreis = this.kreis != 0 ? 0 : -1;
    }

    public void kreis(int k) {
        this.kreis = k;
    }

    public Stein flip() {
        this.kreis = 0;
        this.weiss = !this.weiss;
        this.echt = false;
        return this;
    }

    public int getPfeil(int i) {
        return this.pfeile[(this.position + i) % 6];
    }

    public void setPfeil(int i, int p) {
        this.pfeile[(this.position + i) % 6] = p;
    }

    public String toString() {
        return String.valueOf(this.getPfeil(0)) + " " + this.getPfeil(1) + " " + this.getPfeil(2) + " " + this.getPfeil(3) + " " + this.getPfeil(4) + " " + this.getPfeil(5);
    }

    public static int code(int pp) {
        int p1 = pp % 10;
        int p2 = pp / 10;
        int p = p1 == 0 ? p2 : (p2 == 0 ? p1 : (p1 == p2 ? p1 + 3 : p1 + p2 + 4));
        return p;
    }

    public int code() {
        int s;
        int c = 0;
        int f = 1;
        int w = 0;
        while (w < 6) {
            c += f * Stein.code(this.getPfeil(w));
            ++w;
            f *= 10;
        }
        int n = this.echt ? (this.kreis == 0 ? 1 : (5 - this.kreis) / 2) : (s = 4);
        if (!this.weiss) {
            s += 5;
        }
        return c += s * f;
    }

    public boolean equals(Object s) {
        if (!(s instanceof Stein)) {
            return false;
        }
        Stein sc = ((Stein)s).copy();
        if (this.weiss != sc.weiss || this.echt != sc.echt) {
            return false;
        }
        int i = 0;
        while (i < 12) {
            sc.turn((int)Math.signum(i % 6));
            boolean gleich = true;
            int j = 0;
            while (j < 6) {
                if (Stein.code(this.getPfeil(j)) != Stein.code(sc.getPfeil(j))) {
                    gleich = false;
                    break;
                }
                ++j;
            }
            if (gleich) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void paint(Graphics g, int x, int y, int radius) {
        if (this.kreis != 0) {
            Farbe.stein(g, this.kreis == 1 ? 7 : 8);
            g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        } else if (!this.echt) {
            Farbe.stein(g, 6);
            g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        } else {
            Farbe.stein(g, 9);
            g.fillOval(x - radius + 3, y - radius + 5, radius * 2 - 6, radius * 2 - 6);
        }
        radius -= 3;
        if (this.weiss) {
            Farbe.stein(g, 4);
        } else {
            Farbe.stein(g, 5);
        }
        g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        int i = 0;
        while (i < 6) {
            int p = this.getPfeil(i);
            if (p != 0) {
                double phi = 1.0471975511965976 * (double)i;
                CBVector richt1 = new CBVector(Math.cos(phi), Math.sin(phi)).scale(radius);
                CBVector richt2 = new CBVector(richt1.get(1), -richt1.get(0)).scale(0.11);
                CBVector pos1 = new CBVector(x, y);
                CBVector pos2 = richt1.add(pos1);
                CBVector pos3 = richt1.scale(0.5).add(pos1);
                CBVector pos4 = pos3.add(richt2);
                CBVector pos5 = pos3.sub(richt2);
                if (p % 10 != 0) {
                    Farbe.stein(g, p % 10);
                    g.fillPolygon(new int[]{pos2.getInt(0), pos4.getInt(0), pos5.getInt(0)}, new int[]{pos2.getInt(1), pos4.getInt(1), pos5.getInt(1)}, 3);
                }
                if (p / 10 != 0) {
                    Farbe.stein(g, p / 10);
                    g.fillPolygon(new int[]{pos1.getInt(0), pos4.getInt(0), pos5.getInt(0)}, new int[]{pos1.getInt(1), pos4.getInt(1), pos5.getInt(1)}, 3);
                }
            }
            ++i;
        }
    }

    public int value() {
        int a = 0;
        int b = 0;
        int s = this.kreis == 0 ? 2 : (this.kreis == -1 ? 1 : 4);
        int w = 0;
        while (w < 6) {
            int p = this.pfeile[w];
            int p1 = p % 10;
            int p2 = p / 10;
            if (p != 0 && p1 == p2) {
                ++b;
            } else {
                a = (int)((float)a + (Math.signum(p1) + Math.signum(p2)));
            }
            ++w;
        }
        return (2 * a * (a - 1) + 2 * a * s + 10 * b * (b - 1) + 10 * b * s + 10 * a * b + 2 * s) / 2;
    }

    public void sort() {
        int i = 0;
        while (i < 6) {
            if (this.pfeile[i] % 10 == 0) {
                int n = i;
                this.pfeile[n] = this.pfeile[n] / 10;
            } else if (this.pfeile[i] / 10 > this.pfeile[i] % 10) {
                this.pfeile[i] = this.pfeile[i] % 10 * 10 + this.pfeile[i] / 10;
            }
            ++i;
        }
    }
}

