/*
 * Decompiled with CFR 0.152.
 */
package cbge.physics;

import cbge.CBError;
import java.io.Serializable;
import java.util.Arrays;

public class CBVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte dim;
    private double[] values;

    public CBVector(double ... values) {
        if (values.length == 0) {
            CBError.error("cbge.physics.CBVector.new(double ...): L\ufffdnge = 0");
        } else if (values.length == 1) {
            this.dim = (byte)values[0];
            if (this.dim < 2) {
                CBError.error("cbge.physics.CBVector.new(double ...): L\ufffdnge < 2");
            } else {
                this.values = new double[this.dim];
            }
        } else {
            this.values = values;
            this.dim = (byte)values.length;
        }
    }

    public CBVector set(int koordinate, double value) {
        if (koordinate < 0 || koordinate >= this.dim) {
            CBError.error("cbge.physics.CBVector.set(int, double): Dimensionsfehler (" + koordinate + ")");
        }
        this.values[koordinate] = value;
        return this;
    }

    public double get(int koordinate) {
        if (koordinate < 0 || koordinate >= this.dim) {
            CBError.error("cbge.physics.CBVector.get(int): Dimensionsfehler (" + koordinate + ")");
        }
        return this.values[koordinate];
    }

    public int getInt(int koordinate) {
        if (koordinate < 0 || koordinate >= this.dim) {
            CBError.error("cbge.physics.CBVector.get(int): Dimensionsfehler (" + koordinate + ")");
        }
        return (int)Math.round(this.values[koordinate]);
    }

    public CBVector scale(double scale) {
        double[] newValues = new double[this.dim];
        int i = 0;
        while (i < this.dim) {
            newValues[i] = this.values[i] * scale;
            ++i;
        }
        return new CBVector(newValues);
    }

    public CBVector add(double ... shift) {
        if (shift.length != this.dim) {
            CBError.error("cbge.physics.CBVector.add(double...): Dimensionsfehler (" + shift.length + ")");
        }
        double[] newValues = new double[this.dim];
        int i = 0;
        while (i < this.dim) {
            newValues[i] = this.values[i] + shift[i];
            ++i;
        }
        return new CBVector(newValues);
    }

    public CBVector add(CBVector v) {
        if (v.dim != this.dim) {
            CBError.error("cbge.physics.CBVector.add(CBVector): Dimensionsfehler (" + v.dim + ")");
        }
        return this.add(v.values);
    }

    public CBVector sub(CBVector v) {
        if (v.dim != this.dim) {
            CBError.error("cbge.physics.CBVector.add(CBVector): Dimensionsfehler (" + v.dim + ")");
        }
        return this.add(v.scale((double)-1.0).values);
    }

    public double scalar(CBVector v) {
        if (this.dim != v.dim) {
            CBError.error("cbge.physics.CBVector.scalar(CBVector): Dimensionsfehler (" + v.dim + ")");
        }
        double produkt = 0.0;
        int i = 0;
        while (i < this.dim) {
            produkt += this.values[i] * v.values[i];
            ++i;
        }
        return produkt;
    }

    public double abs() {
        return this.abs(2.0);
    }

    public double abs(double p) {
        if (p <= 0.0) {
            CBError.error("cbge.physics.CBVector.abs(double): Es muss p > 0 sein");
        }
        double n = 0.0;
        int i = 0;
        while (i < this.dim) {
            n += Math.pow(Math.abs(this.values[i]), p);
            ++i;
        }
        return Math.pow(n, 1.0 / p);
    }

    public CBVector norm() {
        if (this.abs() != 0.0) {
            return this.scale(1.0 / this.abs());
        }
        return this;
    }

    public double ang(CBVector v) {
        if (this.dim != v.dim) {
            CBError.error("cbge.physics.CBVector.ang(CBVector): Dimensionsfehler (" + v.dim + ")");
        }
        double thisabs = this.abs();
        double vabs = v.abs();
        if (thisabs == 0.0 || vabs == 0.0) {
            CBError.error("cbge.physics.CBVector.ang(CBVector): Vektor der L\ufffdnge Null");
        }
        return Math.acos(this.scalar(v) / (thisabs * vabs));
    }

    public double angAbs(CBVector v) {
        if (this.dim != 2) {
            CBError.error("cbge.physics.CBVector.angAbs(double): Dimensionsfehler (" + this.dim + ")");
        }
        double a = this.ang(v);
        if (this.ang(v.rot(1.5707963267948966)) > this.ang(v.rot(-1.5707963267948966))) {
            a = Math.PI * 2 - a;
        }
        return a;
    }

    public CBVector rot(double ang) {
        if (this.dim != 2) {
            CBError.error("cbge.physics.CBVector.rot(double): Dimensionsfehler (" + this.dim + ")");
        }
        return new CBVector(Math.cos(ang) * this.values[0] - Math.sin(ang) * this.values[1], Math.sin(ang) * this.values[0] + Math.cos(ang) * this.values[1]);
    }

    public boolean equalsTo(double ... d) {
        return this.equals(d);
    }

    public boolean equals(Object v) {
        if (v instanceof CBVector) {
            return this.dim == ((CBVector)v).dim && Arrays.equals(this.values, ((CBVector)v).values);
        }
        if (v instanceof double[]) {
            return this.dim == ((double[])v).length && Arrays.equals(this.values, (double[])v);
        }
        return false;
    }

    public String toString() {
        String string = "(" + this.values[0];
        int i = 1;
        while (i < this.dim) {
            string = String.valueOf(string) + ", " + this.values[i];
            ++i;
        }
        string = String.valueOf(string) + ")";
        return string;
    }
}

