/*
 * Decompiled with CFR 0.152.
 */
import cbge.CBScreen;
import cbge.event.CBKeyAdapter;
import cbge.event.CBKeyListener;
import cbge.event.CBMouseAdapter;
import cbge.event.CBMouseListener;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;

public class Satz
implements SteinListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient int bearb;
    private transient boolean neu;
    private transient boolean ende;
    private transient CBMouseListener ml;
    private transient CBKeyListener kl;
    private transient SteinListener sl;
    private transient String path;
    Stein[] satz = new Stein[0];

    Satz(boolean weiss, String path) throws Exception {
        this.path = path;
        this.read(weiss);
    }

    Satz(String path) {
        this.path = path;
        try {
            this.read(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.open(null, null);
        this.neu = false;
        this.bearb = -1;
        this.ende = false;
        if (this.satz.length == 0) {
            this.neu();
        }
        this.addKeyListener();
        while (!this.ende) {
            try {
                if (this.neu) {
                    this.neu();
                    this.neu = false;
                }
                if (this.bearb != -1) {
                    this.stein(this.satz[this.bearb]);
                    this.bearb = -1;
                }
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.save();
        CBScreen.removeKeyListener(this.kl);
    }

    private void neu() {
        this.stein(new Stein(true, new int[6]));
    }

    @Override
    public void stein(Stein s) {
        this.remove(s);
        CBScreen.removeKeyListener(this.kl);
        this.close();
        if (s.bearbeiten() && !this.contains(s)) {
            this.add(s);
        }
        this.open(null, null);
        this.addKeyListener();
    }

    private void save() {
        if (this.satz.length > 0) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
                bw.write(this.satz[0].toString());
                int i = 1;
                while (i < this.satz.length) {
                    bw.newLine();
                    bw.write(this.satz[i].toString());
                    ++i;
                }
                bw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void read(boolean weiss) throws Exception {
        String linie;
        BufferedReader br = new BufferedReader(new FileReader(this.path));
        while ((linie = br.readLine()) != null) {
            String[] str = linie.split(" ");
            int[] pfeile = new int[6];
            int i = 0;
            while (i < 6) {
                pfeile[i] = Integer.parseInt(str[i]);
                ++i;
            }
            this.add(new Stein(weiss, pfeile));
        }
        br.close();
    }

    private boolean contains(Stein s) {
        int i = 0;
        while (i < this.satz.length) {
            if (this.satz[i].equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void add(Stein s) {
        Stein[] neu = new Stein[this.satz.length + 1];
        System.arraycopy(this.satz, 0, neu, 0, this.satz.length);
        neu[this.satz.length] = s;
        this.satz = neu;
    }

    boolean remove(Stein s) {
        int i = 0;
        while (i < this.satz.length) {
            if (this.satz[i] == s) {
                Stein[] neu = new Stein[this.satz.length - 1];
                System.arraycopy(this.satz, 0, neu, 0, i);
                System.arraycopy(this.satz, i + 1, neu, i, neu.length - i);
                this.satz = neu;
                return true;
            }
            ++i;
        }
        return false;
    }

    void open(SteinListener sl, Satz gegner) {
        this.sl = sl;
        Stein[] g = gegner == null ? null : gegner.satz;
        this.addMouseListener(g);
        this.paint(CBScreen.getGraphics(), g);
    }

    void close() {
        CBScreen.removeMouseListener(this.ml);
    }

    void paint(Graphics g, Stein[] gegner) {
        int y;
        int x;
        int width = CBScreen.getWidth();
        int height = CBScreen.getHeight();
        int w = width / 100;
        Farbe.satz(g);
        g.fillRect(0, 0, width, height);
        int n = 0;
        while (n < this.satz.length) {
            x = n % w * 100 + 50;
            y = n / w * 100 + 50;
            this.satz[n].paint(g, x, y, 45);
            ++n;
        }
        if (gegner == null) {
            g.setFont(new Font("", 0, 15));
            Farbe.basic(g, 2);
            g.drawString("Anzahl: " + (this.satz.length < 10 ? "0" : "") + this.satz.length, width - 100, height - 20);
        } else {
            n = 0;
            while (n < gegner.length) {
                x = n % w * 100 + 50;
                y = height - (n / w * 100 + 50);
                gegner[n].paint(g, x, y, 45);
                ++n;
            }
        }
        Spiel.draw();
    }

    private void addKeyListener() {
        this.kl = new CBKeyAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void keyPressed(int k) {
                if (k == 10) {
                    Satz.this.neu = true;
                } else if (k == 27) {
                    Satz.this.close();
                    Satz.this.ende = true;
                }
            }
        };
        CBScreen.addKeyListener(this.kl);
    }

    private void addMouseListener(final Stein[] gegner) {
        if (this.ml == null) {
            this.ml = new CBMouseAdapter(){
                private static final long serialVersionUID = 1L;

                @Override
                public void mousePressed(MouseEvent e) {
                    int width = CBScreen.getWidth();
                    int height = CBScreen.getHeight();
                    int w = width / 100;
                    int h = height / 100;
                    int x = e.getX();
                    int y = e.getY();
                    int n = 0;
                    int i = 0;
                    while (i < w) {
                        if (x < (i + 1) * 100) {
                            n += i;
                            break;
                        }
                        ++i;
                    }
                    int j = 0;
                    while (j < h) {
                        if (y < (j + 1) * 100) {
                            n += j * w;
                            break;
                        }
                        ++j;
                    }
                    if (Satz.this.sl == null) {
                        if (e.getButton() == 1 && n < Satz.this.satz.length) {
                            Satz.this.bearb = n;
                        }
                        if (e.getButton() == 3) {
                            Satz.this.neu = true;
                        }
                    } else {
                        if (n < Satz.this.satz.length) {
                            Satz.this.sl.stein(Satz.this.satz[n]);
                            Satz.this.sl.stein(Satz.this.satz[n], e.getButton());
                        }
                        if (gegner != null) {
                            int m = 0;
                            int i2 = 0;
                            while (i2 < w) {
                                if (x < (i2 + 1) * 100) {
                                    m += i2;
                                    break;
                                }
                                ++i2;
                            }
                            int j2 = 0;
                            while (j2 < h) {
                                if (y > height - (j2 + 1) * 100) {
                                    m += j2 * w;
                                    break;
                                }
                                ++j2;
                            }
                            if (m < gegner.length) {
                                Satz.this.sl.stein(gegner[m]);
                                Satz.this.sl.stein(gegner[m], e.getButton());
                            }
                        }
                        if (e.getButton() == 3) {
                            Spiel.close();
                        }
                    }
                }
            };
        }
        CBScreen.addMouseListener(this.ml);
    }
}

